#10/7/24 -created
#12/5/24 -added sound for fun

import pygame
import random
import math

pygame.init()
ds=pygame.display.set_mode((800,600))

#peppino
peppino_x = 400
peppino_y = 300
peppino_speed = 5
peppino_radius = 30

#target
target_x = random.randint(50,750)
target_y = random.randint(50,550)
target_speed = random.randint(3,15)
target_angle = random.randint(1,360)
target_radius = 25

#pillar john
pillar_john_x = 750
pillar_john_y = 550
pillar_john_speed = 2
pillar_john_radius = 15


#background/colors
rows,cols = 15,20 #grid size
square_size = 800//cols
purple = (153,122,153)
purple2 = (97,66,97)
black = (0,0,0)
white = (255,255,255)
yellow = (255,232,140)
red = (255,0,0)
brown = (222,184,135)
skin = (255,170,131)
john1 = (120,104,151)
john2 = (75,63,99)
john3 = (177,120,152)
pillar_eyes = (207,215,96)

#clock/score
fpsClock = pygame.time.Clock()
start_ticks=pygame.time.get_ticks()
score = 0

#mixer
pygame.mixer.set_num_channels(8)
pygame.mixer.music.load("Pizza Tower OST - It's Pizza Time!.mp3")
pygame.mixer.music.set_volume(0.25)
pygame.mixer.music.play(loops=-1,start=20.0)

taunt = pygame.mixer.Sound("pizza-tower-taunt.mp3")
taunt.set_volume(0.15)
peppino_scream = pygame.mixer.Sound("peppinoscream.mp3")
peppino_scream.set_volume(0.20)
congrats = pygame.mixer.Sound("pizza-tower-boss-defeated.mp3")
congrats.set_volume(0.15)

def distance(x1,y1,x2,y2):
    return math.sqrt((x2-x1)**2+(y2-y1)**2)

def drawPeppino(x,y):
    pygame.draw.rect(ds,(skin),(x-30,y-30,50,40))  #Face
    pygame.draw.ellipse(ds,(skin),(x-30,y-40,50,20)) #upper face
    pygame.draw.ellipse(ds,(skin),(x-30,y,50,20))#lower face

    pygame.draw.ellipse(ds,(black),(x-27,y-20,45,35))#void
    pygame.draw.ellipse(ds,(white),(x-20,y-16,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x-20,y-16,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x-15,y-16,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x-10,y-16,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x-5,y-16,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x,y-16,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x+5,y-16,7,10))#teeth
    pygame.draw.ellipse(ds,(skin),(x-30,y-32,50,20)) #upper mouth
    pygame.draw.ellipse(ds,(black),(x-17,y-18,24,5)) #mustache

    pygame.draw.ellipse(ds,(white),(x-20,y+3,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x-15,y+3,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x-10,y+3,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x-5,y+3,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x,y+3,7,10))#teeth
    pygame.draw.ellipse(ds,(white),(x+5,y+3,7,10))#teeth
    pygame.draw.ellipse(ds,(skin),(x-25,y+9,40,10))#lower face

    pygame.draw.ellipse(ds,(black),(x-11,y-32,12,31))#nose
    pygame.draw.ellipse(ds,(skin),(x-10,y-33,10,30))#nose2

    pygame.draw.ellipse(ds,(white),(x-33, y-60,60,15))#Hat
    pygame.draw.rect(ds,(white),(x-20, y-50,30,15)) #Hat2

    pygame.draw.ellipse(ds,(black),(x-25,y-38,17,18))#L Eye
    pygame.draw.ellipse(ds,(white),(x-24,y-37,15,15))#L Eye2
    pygame.draw.ellipse(ds,(black),(x-18,y-30,2,2))#L Eye pupil

    pygame.draw.ellipse(ds,(black),(x-1,y-38,17,18))#r Eye
    pygame.draw.ellipse(ds,(white),(x,y-37,15,15))#R Eye2
    pygame.draw.ellipse(ds,(black),(x+2,y-34,10,10),1)#R Eye3
    pygame.draw.ellipse(ds,(black),(x+6,y-30,2,2))#L Eye pupil
    

def drawTarget(x,y):
    pygame.draw.circle(ds,(brown),(x,y),25) #crust
    pygame.draw.circle(ds,(yellow),(x,y),22) #cheese
    pygame.draw.circle(ds,(red),(x - 12,y - 10),5) #pepperoni
    pygame.draw.circle(ds,(red),(x + 12,y + 10),5) #pepperoni
    pygame.draw.circle(ds,(red),(x - 5,y + 2),5) #pepperoni
    pygame.draw.circle(ds,(red),(x + 3,y + 3),5) #pepperoni
    pygame.draw.circle(ds,(red),(x + 6,y - 8),5) #pepperoni
    pygame.draw.circle(ds,(red),(x - 15,y + 5),5) #pepperoni

def drawPillarJohn(x,y):
    pygame.draw.rect(ds,john2,(x-10,y-10,40,80))#John Base
    pygame.draw.rect(ds,john1,(x-15,y-15,40,80))#John top
    pygame.draw.circle(ds,(black),(x-7,y+12),8)#l eye socket
    pygame.draw.circle(ds,(black),(x+7,y+12),8)#r eye socket
    pygame.draw.circle(ds,(pillar_eyes),(x-9,y+14),1)#l eye
    pygame.draw.circle(ds,(pillar_eyes),(x+8,y+14),1)#r eye
    pygame.draw.rect(ds,john2,(x-16,y,14,12))#John l eyebrow
    pygame.draw.rect(ds,john2,(x+2,y,14,12))#John r eyebrow
    pygame.draw.rect(ds,john1,(x-14,y,12,10))#John l eyebrow2
    pygame.draw.rect(ds,john1,(x+2,y,12,10))#John r eyebrow2
    pygame.draw.ellipse(ds,(john2),(x-14,y+30,30,10),0)#john lip1
    pygame.draw.ellipse(ds,(john1),(x-18,y+32,30,10),0)#john lip2
    pygame.draw.ellipse(ds,(john2),(x-12,y+20,20,10),0)#john nose
    pygame.draw.ellipse(ds,(john3),(x-12,y+20,18,8),0)#john nose2
    
### Moves Pillar John towards Peppino ###
def movePillarJohn():
    global pillar_john_x, pillar_john_y
    
    if pillar_john_x < peppino_x:
        pillar_john_x += pillar_john_speed
    elif pillar_john_x > peppino_x:
        pillar_john_x -= pillar_john_speed

    if pillar_john_y < peppino_y:
        pillar_john_y += pillar_john_speed
    elif pillar_john_y > peppino_y:
        pillar_john_y -= pillar_john_speed


def drawBackground():
    row = 0
    while row < rows:
        col = 0
        while col < cols:
            if (row+col) %2== 0: #checks if even or odd
                color = purple
            else:
                color = purple2
            pygame.draw.rect(ds,color,(col*square_size,row*square_size,square_size,square_size))
            col += 1
        row += 1

            
while True:
    fpsClock.tick(120)
    pygame.event.pump()
    keys = pygame.key.get_pressed()

    #keys
    if keys[pygame.K_ESCAPE]:
        break
    
    if keys[pygame.K_a]:
        peppino_x -= peppino_speed
            
    if keys[pygame.K_d]:
        peppino_x += peppino_speed
            
    if keys[pygame.K_w]:
        peppino_y -= peppino_speed
            
    if keys[pygame.K_s]:
        peppino_y += peppino_speed
        
            
    #forbids peppino from going off screen
    if peppino_x<0+peppino_radius: 
        peppino_x=0+peppino_radius
    if peppino_x>799-peppino_radius:
        peppino_x=799-peppino_radius
    if peppino_y<0+peppino_radius:
        peppino_y=0+peppino_radius
    if peppino_y>599-peppino_radius:
        peppino_y=599-peppino_radius

    #Add shaking effect when Peppino is near the target
    distance_to_target = distance(peppino_x, peppino_y, target_x, target_y)
    if distance_to_target < 200:
        peppino_x += random.randint(-3, 3)
        peppino_y += random.randint(-3, 3)
        
    ############### Ball Physics ##################
        
    #update target position based upon speed/angle
    #calculate displacements
    tx = target_speed * math.cos(math.radians(target_angle))
    ty = -1 * target_speed * math.sin(math.radians(target_angle))
    
    #update position based upon displacements
    target_x += tx
    target_y += ty

    target_bounced=False
    if target_x > 799 - target_radius:
        target_x = 799 - target_radius
        tx=-tx
        target_bounced=True
    if target_x <0+ target_radius:
        target_x =0+ target_radius
        tx=-tx
        target_bounced=True
    if target_y >599- target_radius:
        target_y =599- target_radius
        ty=-ty
        target_bounced=True
    if target_y <0+ target_radius:
        target_y =0+ target_radius
        ty=-ty
        target_bounced=True

    #convert displacements back to angle
    if target_bounced==True:
        target_angle = math.degrees(math.atan2(-ty,tx))

    

    ####### render #######
    drawBackground()#remove this to see peppinos true form
    drawPeppino(peppino_x,peppino_y)
    drawTarget(target_x,target_y)
    drawPillarJohn(pillar_john_x, pillar_john_y)
    movePillarJohn()
    
    
    
    ### update score and check targets ###
    if distance(peppino_x,peppino_y,target_x,target_y)< peppino_radius+target_radius:
        taunt.play()
        score += 1
        target_x = random.randint(50,750)
        target_y = random.randint(50,550)
        target_speed = random.randint(3,15)
        target_angle = random.randint(1,360)
        
    ### endgame conditions ###
    myfont=pygame.font.SysFont("Comic Sans",36,bold=False,italic=False)
    time_left = 60-(pygame.time.get_ticks()-start_ticks)/1000
    score_text = myfont.render("Score: " + str(score), True, yellow)
    time_text = myfont.render("Time Left: " + str(round(time_left, 1)), True, yellow)
    ds.blit(score_text,(10,10))
    ds.blit(time_text,(10,50))

    pillar_john_center_x = pillar_john_x+20
    pillar_john_center_y = pillar_john_y+40
    if distance(peppino_x, peppino_y, pillar_john_center_x, pillar_john_center_y) < peppino_radius + pillar_john_radius:
        peppino_scream.play()
        ds.fill((0, 0, 0))
        game_over_text = pygame.font.SysFont("Comic Sans", 36).render("You were caught by Pillar John", True, yellow)
        ds.blit(game_over_text, (125, 250))
        pygame.display.update()
        pygame.time.delay(3000)
        break
    
    if time_left <= 0:
        pygame.mixer.music.stop()
        congrats.play()
        ds.fill((0,0,0))
        game_over_text = myfont.render("Game Over! Pizzas Devoured: " + str(score), True, yellow)
        ds.blit(game_over_text,(125,250))
        pygame.display.update()
        pygame.time.delay(3000)
        break
    
    pygame.display.update()
pygame.mixer.music.stop()
pygame.display.quit()
